<?php require_once("my-header.php"); include("admin-includes/jc-view-house-fellowship-all.php");?>

  <!--start main wrapper-->
  <main class="main-wrapper">
    <div class="main-content">
      <!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-4">
					<div class="breadcrumb-title pe-3">Offering Reports</div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">Offering Information</li>
							</ol>
						</nav>
					</div>
					 
				</div>
				<!--end breadcrumb-->
        <hr><?php require_once("admin-includes/jc-offering-process.php");?>
        		 <?php
											include("admin-includes/update_column.php");
											include("admin-includes/deleteclass.php");
											//deleteclass
											
											?>
                                       
        
				<div class="card">
					<div class="card-body">
                   	<div class="table-responsive">
							<table id="example2" class="table table-striped table-bordered">
								<thead>
                                <tr>
			 											<th>Service Date </th>
														<th>Service Name</th>
														<th>Offering Name</th>
														<th>Amount</th>
													  <th>Created Date</th>
												 	   
												 	   <th>Registered By</th>
												<th>Status</th>
														<th>More</th>
													 
													</tr>
                                        </thead>
                                        <tbody>
                                        <?php
										 include("admin-includes/jc-view-offering.php");
												
												?>
                                        </tbody>
                                        <tfoot>
                                        <tr>
			 											<th>Service Date </th>
														<th>Service Name</th>
														<th>Offering Name</th>
														<th>Amount</th>
													  <th>Created Date</th>
												 	   
												 	   <th>Registered By</th>
												<th>Status</th>
														<th>More</th>
													 
													</tr>
                                        </tfoot>
							</table> 
						</div>
					</div>
				</div>

				<div class="card">
					<div class="card-body">
                   <div class="table-responsive">
				<?php
require_once("app-config/DB_config.php");

$query = "
    SELECT SUM(o.amount) AS total, DATE(o.service_date) AS service_date, o.service_type, g.name AS giving_type
    FROM offering o
    JOIN giving_type g ON o.giving_type = g.id
    GROUP BY DATE(o.service_date), o.service_type, g.name
";
$result = $conn->query($query);
$data = [];

// Organize data by `giving_type` and `service_date`
while ($row = $result->fetch_assoc()) {
    $service_date = $row['service_date'];
    $giving_type = $row['giving_type'];
    $data[$giving_type][$service_date] = $row['total'];
}

$service_dates = array_unique(array_merge(...array_values(array_map('array_keys', $data))));
sort($service_dates); // Ensure dates are sorted
?>

<canvas id="myChart"></canvas>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // PHP data to JavaScript
    const data = <?php echo json_encode($data); ?>;
    const serviceDates = <?php echo json_encode($service_dates); ?>;

    // Colors for each `giving_type`
    const colors = ['rgba(75, 192, 192, 0.5)', 'rgba(255, 99, 132, 0.5)', 'rgba(54, 162, 235, 0.5)', 'rgba(255, 206, 86, 0.5)'];
    const borderColors = ['rgba(75, 192, 192, 1)', 'rgba(255, 99, 132, 1)', 'rgba(54, 162, 235, 1)', 'rgba(255, 206, 86, 1)'];
    
    // Create datasets for each `giving_type`
    const datasets = Object.keys(data).map((givingType, index) => ({
        label: givingType,  // This is the `giving_type.name` from PHP
        data: serviceDates.map(date => data[givingType][date] || 0),  // Fill with 0 if no data for date
        backgroundColor: colors[index % colors.length],
        borderColor: borderColors[index % borderColors.length],
        borderWidth: 1
    }));

    const ctx = document.getElementById('myChart').getContext('2d');
    const myChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: serviceDates,
            datasets: datasets
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'top' }
            },
            onClick: (event, elements) => {
                if (elements.length > 0) {
                    const datasetIndex = elements[0].datasetIndex;
                    const dataIndex = elements[0].index;
                    const selectedDate = serviceDates[dataIndex];
                    const selectedGivingType = datasets[datasetIndex].label;  // `giving_type.name`
                    alert(`Clicked on: ${selectedGivingType} for date: ${selectedDate}`);
                }
            },
            scales: {
                y: { beginAtZero: true },
                x: { stacked: true },
                y: { stacked: true }
            }
        }
    });
</script>



						</div>
					</div>
				</div>


    </div>
  </main>

 

  <!--end main wrapper-->

<?php require_once("my-footer.php"); ?>

 