<?php require_once("my-header.php");
include("admin-includes/view-application-external.php");
?>

<?php
$json = false;

 
    // SQL query to get workers data
    $query = 'SELECT worker_id, surname, first_name, phone_number, email_address, home_address, longi, lati FROM js_workers WHERE longi != 0';
    
    $stmt = $conn->prepare($query);
    $stmt->execute();
    
    $res = $stmt->get_result();
    $data = $res->fetch_all(MYSQLI_ASSOC);
    $json = json_encode($data);  // Convert PHP array to JSON
 

$conn->close();  // Close the database connection
?>
<script src='https://polyfill.io/v3/polyfill.min.js?features=default'></script>
<script>
    <?php
        // Convert the PHP variable into a JavaScript variable
        printf('const workersData = %s;', $json ?: '[]');
    ?>

    function initMap() {
        // Default center: Lagos, Nigeria
        var defaultCenter = { lat: <?php echo $latii; ?>, lng: <?php echo $longii; ?> };
   
        var options = {
            zoom: 10,
            center: defaultCenter  // Use default center if lati/longii are undefined
        };

        var map = new google.maps.Map(document.getElementById('map'), options);

        // Debug: Print workersData to console
        console.log("Workers Data:", workersData);

        // Function to add marker with tooltip
        function addMarker(coords, tooltipContent) {
            var marker = new google.maps.Marker({
                position: coords,
                map: map
            });

            var infoWindow = new google.maps.InfoWindow({
                content: `<div style="max-width: 200px; font-size: 12px; line-height: 1.5; color: #333;">
                    ${tooltipContent}
                  </div>`  // Improved font size and color
            });

            // Display tooltip on marker click
            marker.addListener('click', function() {
                infoWindow.open(map, marker);
            });
        }

        // Add markers for each worker if data exists
        if (workersData && workersData.length > 0) {
            workersData.forEach(worker => {
                // Check if worker has valid latitude and longitude, excluding coordinates with 0 values
                if ((worker.lati && worker.longi && worker.lati != 0 && worker.longi != 0)) 
{
                    console.log(`Adding marker for: ${worker.first_name} ${worker.surname} at (${worker.lati}, ${worker.longi})`);

                    let latlng = new google.maps.LatLng(worker.lati, worker.longi);

                    // Tooltip content with worker details
                    let tooltipContent = `
                        <div>
                            <strong>Name:</strong> ${worker.first_name} ${worker.surname}<br>
                            <strong>Phone:</strong> ${worker.phone_number}<br>
                            <strong>Email:</strong> ${worker.email_address}<br>
                            <strong>Address:</strong> ${worker.home_address}
                        </div>
                    `;

                    // Add marker with tooltip
                    addMarker(latlng, tooltipContent);
                } else {
                    console.log(`Skipping marker for worker: ${worker.first_name} ${worker.surname} due to invalid lat/long.`);
                }
            });
        }
    }
</script>


<!--start main wrapper-->
<main class="main-wrapper">
    <div class="main-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-4">
            <div class="breadcrumb-title pe-3">Worker's MAP</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Worker's MAP</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->
        
        <div class="card">
            <div id='map' style="height: 500px; width: 100%;"></div>

            <!-- Google Maps API Script -->
            <script async defer src='https://maps.googleapis.com/maps/api/js?key=<?php echo $googleapi; ?>&callback=initMap'></script>
        </div>
    </div>
</main>

<!--end main wrapper-->

<?php require_once("my-footer.php"); ?>
