<?php require_once("my-header.php");
include("admin-includes/view-application-external.php");
?>

<?php
$json = false;

if (isset($_POST['search'])) {
    // SQL query to get workers data
    $query = 'SELECT worker_id, surname, first_name, phone_number, email_address, home_address, longi, lati FROM js_workers WHERE 1';
    
    $stmt = $conn->prepare($query);
    $stmt->execute();
    
    $res = $stmt->get_result();
    $data = $res->fetch_all(MYSQLI_ASSOC);
    $json = json_encode($data);  // Convert PHP array to JSON
}

$conn->close();  // Close the database connection
?>

<script src='https://polyfill.io/v3/polyfill.min.js?features=default'></script>
<script>
    <?php
        // Convert the PHP variable into a JavaScript variable
        printf('const workersData = %s;', $json ?: '[]');
    ?>

    function initMap() {
        var options = {
            zoom: 10,
            center: { lat: <?php echo $latii; ?>, lng: <?php echo $longii; ?> }  // Set the initial center of the map
        };
        var map = new google.maps.Map(document.getElementById('map'), options);

        function addMarker(coords, tooltipContent) {
            var marker = new google.maps.Marker({
                position: coords,
                map: map
            });

            var infoWindow = new google.maps.InfoWindow({
                content: tooltipContent
            });

            // Display tooltip on marker click
            marker.addListener('click', function() {
                infoWindow.open(map, marker);
            });
        }

        if (workersData && workersData.length > 0) {
            workersData.forEach(worker => {
                // Check if latitude and longitude are available
                if (worker.lati && worker.longi) {
                    let latlng = new google.maps.LatLng(worker.lati, worker.longi);

                    // Construct tooltip content
                    let tooltipContent = `
                        <div>
                            <strong>Name:</strong> ${worker.first_name} ${worker.surname}<br>
                            <strong>Phone:</strong> ${worker.phone_number}<br>
                            <strong>Email:</strong> ${worker.email_address}<br>
                            <strong>Address:</strong> ${worker.home_address}
                        </div>
                    `;

                    // Add marker with tooltip content
                    addMarker(latlng, tooltipContent);
                }
            });
        }
    }
</script>

<!--start main wrapper-->
<main class="main-wrapper">
    <div class="main-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-4">
            <div class="breadcrumb-title pe-3">Service Type Setup</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Service Type Setup Information</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->
        
        <div class="card">
            <div id='map' style="height: 500px; width: 100%;"></div>

            <!-- Google Maps API Script -->
            <script async defer src='https://maps.googleapis.com/maps/api/js?key=<?php echo $googleapi; ?>&callback=initMap'></script>
        </div>
    </div>
</main>

<!--end main wrapper-->

<?php require_once("my-footer.php"); ?>
