<?php

include("app-config/DB_config.php");

if ( isset($_GET['zone_id'])) {
    $zone_id = $_GET['zone_id'];
 
    // Fetch areas based on zone_id
    $areaStmt = $conn->prepare("SELECT `id`, `name` FROM `areas` WHERE `zone_id` = ? AND `status` = 1");
    $areaStmt->bind_param("i", $zone_id);
    $areaStmt->execute();
    $areaResult = $areaStmt->get_result();

    // Generate options for the areas combo box
    while ($area = $areaResult->fetch_assoc()) {
        echo "<option value='" . htmlspecialchars($area['id']) . "'>" . htmlspecialchars($area['name']) . "</option>";
    }
}
?>