function initMap() {
  // Initialize the map centered at a default location (you can change this)
  const map = new google.maps.Map(document.getElementById("map"), {
    zoom: 10,
    center: { lat: 0, lng: 0 }, // Will adjust dynamically
  });

  // Worker data - dynamically populated by PHP
  const workers = [
    <?php
    

    // SQL query to get workers data
    $query = "SELECT worker_id, surname, first_name, phone_number, email_address, home_address, longi, lati FROM js_workers WHERE 1";
    $result = $connection->query($query);

    // Check if any results were returned
    if ($result->num_rows > 0) {
        // Loop through each row in the result
        while ($row = $result->fetch_assoc()) {
            echo "{ lat: " . $row['lati'] . ", lng: " . $row['longi'] . ", info: '";
            echo "Name: " . $row['first_name'] . " " . $row['surname'] . "<br>";
            echo "Phone: " . $row['phone_number'] . "<br>";
            echo "Email: " . $row['email_address'] . "<br>";
            echo "Address: " . $row['home_address'] . "'";
            echo " },";
        }
    } else {
        echo "console.log('No results found');";
    }

    // Close the database connection
    $connection->close();
    ?>
  ];

  // Add markers for each worker
  workers.forEach(worker => {
    const marker = new google.maps.Marker({
      position: { lat: worker.lat, lng: worker.lng },
      map: map,
    });

    const infoWindow = new google.maps.InfoWindow({
      content: worker.info,
    });

    // Show info window on marker click
    marker.addListener("click", () => {
      infoWindow.open(map, marker);
    });
  });

  // Adjust map center to the first worker's location (if available)
  if (workers.length > 0) {
    map.setCenter({ lat: workers[0].lat, lng: workers[0].lng });
  }
}
