<?php

function verifyNINPhone($accessToken, $phoneNumber, $firstname, $lastname) {
    // Initialize cURL
    $curl = curl_init();

    // Set cURL options
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.qoreid.com/v1/ng/identities/nin-phone/" . urlencode($phoneNumber),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_HTTPHEADER => [
            "Accept: application/json",
            "Authorization: Bearer " . $accessToken,
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => json_encode([
            "firstname" => $firstname,
            "lastname" => $lastname
        ]),
    ]);

    // Execute the request and capture the response
    $response = curl_exec($curl);

    // Check for cURL errors
    if (curl_errno($curl)) {
        echo 'Error:' . curl_error($curl);
        curl_close($curl);
        return null; // Return null if there's an error
    }

    // Close cURL session
    curl_close($curl);

    // Decode the JSON response
    $data = json_decode($response, true);

    // Check if decoding was successful
    if (json_last_error() === JSON_ERROR_NONE) {
        return $data; // Return the decoded response
    } else {
        // Handle JSON decode error
        echo "Failed to decode JSON response: " . json_last_error_msg() . PHP_EOL;
        return null; // Return null if decoding fails
    }
}

// Example usage:
$accessToken = "eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICIzaVgtaEFrS3RmNUlsYWhRcElrNWwwbFBRVlNmVnpBdG9WVWQ4UXZ1OHJFIn0.eyJleHAiOjE3MjMxMTU0MjUsImlhdCI6MTcyMzEwODIyNSwianRpIjoiYTk4NTVlNzQtMGM2YS00NTY3LWI5ODItZjRjYzhkZjQyOTExIiwiaXNzIjoiaHR0cHM6Ly9hdXRoLnFvcmVpZC5jb20vYXV0aC9yZWFsbXMvcW9yZWlkIiwiYXVkIjpbInFvcmVpZGFwaSIsImFjY291bnQiXSwic3ViIjoiZTk3MDA1ZWEtYzg1ZS00OTIyLTg1MTUtMzIwMmNlZjg4NjhkIiwidHlwIjoiQmVhcmVyIiwiYXpwIjoiNEZGRjJFNDRaMENLVlc3TTVIRFIiLCJhY3IiOiIxIiwicmVhbG1fYWNjZXNzIjp7InJvbGVzIjpbIm9mZmxpbmVfYWNjZXNzIiwidW1hX2F1dGhvcml6YXRpb24iLCJkZWZhdWx0LXJvbGVzLXFvcmVpZCJdfSwicmVzb3VyY2VfYWNjZXNzIjp7InFvcmVpZGFwaSI6eyJyb2xlcyI6WyJ2ZXJpZnlfbmluX3Bob25lX3N1YiIsInZlcmlmeV9idm5fcHJlbWl1bV9zdWIiXX0sImFjY291bnQiOnsicm9sZXMiOlsibWFuYWdlLWFjY291bnQiLCJtYW5hZ2UtYWNjb3VudC1saW5rcyIsInZpZXctcHJvZmlsZSJdfX0sInNjb3BlIjoicHJvZmlsZSBlbWFpbCIsImVudmlyb25tZW50Ijoic2FuZGJveCIsImNsaWVudElkIjoiNEZGRjJFNDRaMENLVlc3TTVIRFIiLCJjbGllbnRIb3N0IjoiMTkyLjE2OC4xOTMuMTQwIiwib3JnYW5pc2F0aW9uSWQiOjIyOTk1MCwiZW1haWxfdmVyaWZpZWQiOmZhbHNlLCJwcmVmZXJyZWRfdXNlcm5hbWUiOiJzZXJ2aWNlLWFjY291bnQtNGZmZjJlNDR6MGNrdnc3bTVoZHIiLCJhcHBsaWNhdGlvbklkIjoxOTc4NywiY2xpZW50QWRkcmVzcyI6IjE5Mi4xNjguMTkzLjE0MCJ9.OtII1uyiz5LdEK1Bm7aFLWLOsLb-WYTSb8qAaRl--HnP773vGH_-KZv1Nw2CAvHvNXLCLNgjoZL_UqSj8QOVcOHt1HXdc4ThTanvqgWvD7zm6xeevLTG4uYr-spKGslTziLTVxUzQoPFc02e7gfR-Vv_18poyJXAeIU3lDwgD2T6qJPxPJR6ZaNqstPtb9fGeA_4xZBn7v4nnG9bf-YHPjYdlGSGXQzu0C38oiMeLUwJQ29O42zicR46ILSdLetkXaTztORJ0VayaLrExjc6vab74nwmFwgMse7lZMzwuqyqo7rqaorMuiYHDzKGeRvZ_wD_QM7Vpf4AlkczNtQSAA";
$phoneNumber = "08000000000";
$firstname = "John";
$lastname = "Smith";

$response = verifyNINPhone($accessToken, $phoneNumber, $firstname, $lastname);

if ($response) {
    // Handle the response
    if ($response['status']['state'] === 'complete' && $response['status']['status'] === 'id_mismatch') {
        echo "NIN and phone number mismatch for applicant.\n";
        echo "NIN Provided: " . $response['nin']['nin'] . "\n";
        echo "Actual Firstname: " . $response['nin']['firstname'] . "\n";
        echo "Actual Lastname: " . $response['nin']['lastname'] . "\n";
        echo "Middle Name: " . $response['nin']['middlename'] . "\n";
        echo "Phone: " . $response['nin']['phone'] . "\n";
        echo "Gender: " . $response['nin']['gender'] . "\n";
        echo "Photo (Base64): " . $response['nin']['photo'] . "\n";
        echo "Birthdate: " . $response['nin']['birthdate'] . "\n";
        echo "Residence Address: " . $response['nin']['residence']['address1'] . "\n";
        echo "LGA: " . $response['nin']['residence']['lga'] . "\n";
        echo "State: " . $response['nin']['residence']['state'] . "\n";
    } else {
        echo "NIN and phone number matched.\n";
    }
} else {
    echo "Failed to verify NIN and phone number." . PHP_EOL;
}

?>
