<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include("app-config/DB_config.php");
include("class_file.php");

$myName = new Name();

 

$requestChannelId = $myName->showName($conn, "SELECT `requestChannelId` FROM `pouchi_setup` WHERE `status` = '1'");
$requestChannel = $myName->showName($conn, "SELECT `requestChannel` FROM `pouchi_setup` WHERE `status` = '1'");
$requestChannelType = $myName->showName($conn, "SELECT `requestChannelType` FROM `pouchi_setup` WHERE `status` = '1'");
$requestApplicationCode = $myName->showName($conn, "SELECT `requestApplicationCode` FROM `pouchi_setup` WHERE `status` = '1'");
$requestApplicationModule = $myName->showName($conn, "SELECT `requestApplicationModule` FROM `pouchi_setup` WHERE `status` = '1'");
$requestPartnerCode = $myName->showName($conn, "SELECT `requestPartnerCode` FROM `pouchi_setup` WHERE `status` = '1'");
$username = $myName->showName($conn, "SELECT `username` FROM `pouchi_setup` WHERE `status` = '1'");
$password = $myName->showName($conn, "SELECT `password` FROM `pouchi_setup` WHERE `status` = '1'");
$rememberMe = $myName->showName($conn, "SELECT `rememberMe` FROM `pouchi_setup` WHERE `status` = '1'");
$baseurl = $myName->showName($conn, "SELECT `url` FROM `pouchi_setup` WHERE `status` = '1'");
$full_url = $baseurl . "identityservice/rest/api/integration/authentication/credential";

$data = array(
    "requestChannelId" => $requestChannelId,
    "requestChannel" => $requestChannel,
    "requestChannelType" => $requestChannelType,
    "requestApplicationCode" => $requestApplicationCode,
    "requestApplicationModule" => $requestApplicationModule,
    "requestPartnerCode" => $requestPartnerCode,
    "username" => $username,
    "password" => $password,
    "rememberMe" => $rememberMe === 'true' ? true : false
);

$ch = curl_init($full_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

$response = curl_exec($ch);

if ($response === false) {
    echo json_encode(array("message" => "Error processing request: " . curl_error($ch)));
} else {
    $response_data = json_decode($response, true);

    if ($response_data['responseCode'] == 200) {
        // Login successful
        $token = $response_data['data']['authorization']['token'];
        $refreshToken = $response_data['data']['authorization']['refreshToken'];
        
        // Here you might want to save these tokens or use them as needed
        echo json_encode(array(
            "message" => $response_data['responseMessage'],
            "token" => $token,
            "refreshToken" => $refreshToken,
            "responseTime" => $response_data['responseTime']
        ));
    } else {
        // Login failed or other response
        echo json_encode(array(
            "message" => $response_data['responseMessage'],
            "responseCode" => $response_data['responseCode']
        ));
    }
}

curl_close($ch);
$conn->close();
?>