<?php 
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

  

header("Content-type: application/json");
error_reporting(0);
include("SendingSMS.php");
include("app-config/DB_config.php");
require_once('class_file.php');
require_once('view-application-details.php');


$myName = new Name();
$json = json_decode(file_get_contents('php://input'), true);

 $phone = $json["phone"] ?? '';
//$phone = "09058586585";
 $otp = mt_rand(1111, 9999);
    $account_number = "VS" . rand(10, 99) . rand(10, 99) . rand(11, 89) . rand(10, 99);
$validated_number = validate_nigeria_phone_number($phone);

if (is_invalid_prefix($validated_number)) {
    echo json_encode(array("statusCode" => 201, "message" => "Ooops! Invalid number. Please check and try again."));
    exit;
}

if ($validated_number) {
    $phone = $validated_number;
    $phone2 = $validated_number;
    
    if (empty($phone)) {
        echo json_encode(array("statusCode" => 201, "message" => "Phone Number is empty. Please try again later."));
        exit;
    }

    $query = $conn->prepare("SELECT id, account_number, name, created_date FROM user_unit WHERE phone = ? OR phone LIKE ?");
    $likePhone = '%' . $phone . '%';
    $query->bind_param("ss", $phone, $likePhone);
    $query->execute();
    $result = $query->get_result();

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $id = $row['id'];
            $account_number = $row['account_number'];
            $name = $row['name'];
            $created_date = $row['created_date'];

            $wallet_num = $myName->showName($conn, "SELECT accountNumber FROM wallet_info WHERE registeredby = ? AND accountName != '' AND primary_wallet = 1 LIMIT 1", 's', $account_number);
            
            if (!empty($wallet_num) || !empty($name)) {
                echo json_encode(array("statusCode" => 202, "message" => "User Already registered.", "name" => $name, "phone" => $phone, "vsid" => $account_number, "wallet_number" => $wallet_num, "created_date" => $created_date));
                exit;
            } else {
                $conn->query("DELETE FROM user_unit WHERE phone = '$phone' OR phone LIKE '$likePhone' OR account_number = '$account_number'");
                $conn->query("DELETE FROM wallet_info WHERE phone = '$phone' OR phone LIKE '$likePhone' OR registeredby = '$account_number'");
                $conn->query("DELETE FROM otp WHERE phone = '$phone' OR phone LIKE '$likePhone' OR account_number = '$account_number'");
            }
        }
    }

   

    $otpQuery = $conn->prepare("SELECT otpnumber FROM otp WHERE phone LIKE ? AND status_value = '0'");
    $otpQuery->bind_param("s", $likePhone);
    $otpQuery->execute();
    $otpResult = $otpQuery->get_result();

     if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $id = $row['id'];
            $account_number = $row['account_number'];
            $name = $row['name'];
            $created_date = $row['created_date'];
        echo json_encode(array("statusCode" => 200, "message" => "OTP previously sent to this phone number. Thank you.", "phone" => $phone, "otp" => $customer['otpnumber'], "vsid" => $account_number));
    }  
    } else {
        $stmt = $conn->prepare("INSERT INTO otp (account_number, otpnumber, status_value, phone, created_date) VALUES (?, ?, '0', ?, ?)");
        $stmt->bind_param("ssss", $account_number, $otp, $phone2, $datetime);
        
        if ($stmt->execute()) {
            $message = $inst_name." registration OTP! Your OTP is $otp. Please use it within 3 minutes.";
            
            $apikey_1 = $myName->showName($conn, "SELECT `apikey` FROM `smsapi` WHERE `status` = '1'");
            $email_1 = $myName->showName($conn, "SELECT `email` FROM `smsapi` WHERE `status` = '1'");
            $Sending = new SendingSMS(); 
            $Sending->smsAPI($phone, "APP", $message, $apikey_1, $email_1);
            
            echo json_encode(array("statusCode" => 200, "message" => "OTP sent successfully. Please check your SMS.", "phone" => $phone, "vsid" => $account_number, "otp" => $otp));
        } else {
            echo json_encode(array("statusCode" => 201, "message" => "We cannot send OTP at this time. Please try again later.", "phone" => $phone));
        }
    }
} else {
    echo json_encode(array("statusCode" => 201, "message" => "Invalid Nigerian phone number. Please use 09099797979 format. Thank you."));
}

function validate_nigeria_phone_number($phone_number) {
    $phone_number = preg_replace("/[^0-9]/", "", $phone_number);

    if (substr($phone_number, 0, 3) != "234") {
        $phone_number = "234" . substr($phone_number, -10);
    }

    return (strlen($phone_number) == 13) ? $phone_number : false;
}

function is_invalid_prefix($phone_number) {
    $phone_first_3 = substr($phone_number, 0, 3);
    return in_array($phone_first_3, ["255", "919", "601", "233"]);
}
?>
