<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header("Content-type: application/json");

include("app-config/DB_config.php"); 
include("class_file.php");
include("view-application-details.php");
include("SendingSMS.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

$mail = new PHPMailer(true);

$myName = new Name();

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $json = json_decode(file_get_contents('php://input'), true); // Decode the JSON data
    $otp = $json["otp"] ?? '';
    $code = $json["code"] ?? '';

    if (empty($code) || empty($otp)) {
        echo json_encode(array("statusCode" => 201, "errorMessage" =>"An important field is empty. Please try again later."));
        exit;
    }

    $statement = "SELECT * FROM `otp` WHERE `account_number` = '$code' AND `otpnumber` = '$otp' order by id DESC LIMIT 1";
    $result = mysqli_query($conn, $statement) or die("ERROR OCCURRED: " . mysqli_error($conn));

    if (mysqli_num_rows($result) > 0) {
        $customer = mysqli_fetch_assoc($result);
        $emailing = $customer['account_number'];

        $sql = "UPDATE `otp` SET `status_value` = '1' WHERE `account_number` = '$code' AND `otpnumber` = '$otp'";
        mysqli_query($conn, $sql) or die("ERROR OCCURRED: " . mysqli_error($conn));

        echo json_encode(array("statusCode" => 200, "errorMessage" => "OTP validated successfully. Thank you.", "phone" => $phone, "wynkid" => $code));
    } else {
        echo json_encode(array("statusCode" => 201, "errorMessage" =>"OTP not valid. Please check and try again later."));
    }
} else {
    echo json_encode(array("statusCode" => 201, "errorMessage" => "Invalid request method. Please use POST."));
}

function xtra_clean_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}
?>
