<?php

function getAccessToken($clientId, $secret) {
    // Initialize cURL
    $curl = curl_init();

    // Set cURL options
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.qoreid.com/token",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_HTTPHEADER => [
            "Accept: text/plain",
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => json_encode([
            "clientId" => $clientId,
            "secret" => $secret
        ]),
    ]);

    // Execute the request and capture the response
    $response = curl_exec($curl);

    // Check for cURL errors
    if (curl_errno($curl)) {
        echo 'Error:' . curl_error($curl);
        curl_close($curl);
        return null; // Return null if there's an error
    }

    // Close cURL session
    curl_close($curl);

    // Decode the JSON response
    $data = json_decode($response, true);

    // Check if decoding was successful and if the accessToken exists
    if (json_last_error() === JSON_ERROR_NONE && isset($data['accessToken'])) {
        return $data['accessToken']; // Return the access token
    } else {
        // Handle JSON decode error or missing token
        echo "Failed to decode JSON response or accessToken not found: " . json_last_error_msg() . PHP_EOL;
        return null; // Return null if decoding fails or token is not found
    }
}

// Example usage:
//$clientId = "4FFF2E44Z0CKVW7M5HDR";
//$secret = "bbfcbf212b0a4a4597343564280b3a3d";

/*$token = getAccessToken($clientId, $secret);

if ($token) {
    echo "Access Token: " . $token . PHP_EOL;
} else {
    echo "Failed to retrieve access token." . PHP_EOL;
}
*/
?>
