<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header("Content-type: application/json");
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

//error_reporting(0);

include("SendingSMS.php");
include("app-config/DB_config.php");
require_once('class_file.php');
require_once('view-application-details.php');
require_once('verify_authentication.php');

$myName = new Name();
$json = json_decode(file_get_contents('php://input'), true);
$phoneNumber = $json["phoneNumber"] ?? '';
$firstname = $json["firstname"] ?? '';
$lastname = $json["lastname"] ?? ''; 
$middlename = $json["middlename"] ?? ''; 
$account_number = $json["account_number"] ?? ''; 
$usertype = 1;
$email = "";
$datetime = date("Y-m-d H:i:s");

// Check if the required fields are provided
if (empty($phoneNumber) || empty($firstname) || empty($lastname) || empty($account_number)) {
    echo json_encode(['error' => 'phoneNumber, firstname, lastname, and account_number are required.']);
    exit;
}

// Get clientId and secret from the database
$clientId = $myName->showName($conn, "SELECT `clientId` FROM `qoreid` WHERE `status` = '1'");
$secret = $myName->showName($conn, "SELECT `secret` FROM `qoreid` WHERE `status` = '1'");

$accessToken = getAccessToken($clientId, $secret);

// Function to verify NIN and phone number
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.qoreid.com/v1/ng/identities/nin-phone/" . urlencode($phoneNumber),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
        "Accept: application/json",
        "Authorization: Bearer " . $accessToken,
        "Content-Type: application/json"
    ],
    CURLOPT_POSTFIELDS => json_encode([
        "firstname" => $firstname,
        "lastname" => $lastname
    ]),
]);

$response = curl_exec($curl);

if (curl_errno($curl)) {
    echo json_encode(['error' => curl_error($curl)]);
    curl_close($curl);
    exit;
}

curl_close($curl);

$responseData = json_decode($response, true);

if (json_last_error() === JSON_ERROR_NONE) {
    // Extract and return the necessary data
    $id = $responseData['id'] ?? null;
    $applicantFirstname = $responseData['applicant']['firstname'] ?? '';
    $applicantLastname = $responseData['applicant']['lastname'] ?? '';
    $ninCheckStatus = $responseData['summary']['nin_check']['status'] ?? '';
    $ninCheckFirstNameMatch = $responseData['summary']['nin_check']['fieldMatches']['firstname'] ?? false;
    $ninCheckLastNameMatch = $responseData['summary']['nin_check']['fieldMatches']['lastname'] ?? false;
    $state = $responseData['status']['state'] ?? '';
    $status = $responseData['status']['status'] ?? '';

    $nin = $responseData['nin']['nin'] ?? '';
    $ninFirstname = $responseData['nin']['firstname'] ?? '';
    $ninLastname = $responseData['nin']['lastname'] ?? '';
    $ninMiddlename = $responseData['nin']['middlename'] ?? '';
    $ninPhone = $responseData['nin']['phone'] ?? '';
    $ninGender = $responseData['nin']['gender'] ?? '';
    $ninBirthdate = $responseData['nin']['birthdate'] ?? '';
    $ninPhoto = $responseData['nin']['photo'] ?? ''; // This is the base64 encoded photo
    $ninAddress = $responseData['nin']['address'] ?? '';

    // If the status is "verified", show a specific message
    if ($status === 'verified') {
        // Check if user already exists
        $stmt = $conn->prepare("SELECT COUNT(*) FROM `user_unit` WHERE `account_number` = ? OR `phone` = ?");
        $stmt->bind_param("ss", $account_number, $phoneNumber);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();

        if ($count > 0) {
            echo json_encode(['error' => 'Information already exists in the database. Please check and try again later.']);
        } else {
            // Generate a random password and UUID
            $password = rand(10, 99).rand(10, 99).rand(10, 99).rand(10, 99);
            $uuid = uniqid('', true);

            // Hash the password
            $encrypted_password = password_hash($password, PASSWORD_BCRYPT);

            $name = $firstname . " " . $middlename . " " . $lastname;

            // Prepare the SQL query
   $stmt = $conn->prepare("INSERT INTO `user_unit`(
    `usertype`, `name`, `firstname`, `lastname`, `middlename`, 
    `account_number`, `phone`, `email`, `address`, `created_date`, 
    `registeredby`, `status`, `unique_id`, `encrypted_password`, 
    `r_fname`, `r_lname`, `r_mname`, `dob`, `picture`, 
    `gender`, `id_number`, `irrelivant`
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

if (!$stmt) {
    // Output error message if prepare() fails
    
    
    
    
    
      echo json_encode([
                    "status" => 404,
                    "statusCode" => 404,
                    "message" => "Prepare failed: " . $conn->error
                 ]);
/*    echo json_encode([
        "error" => "Prepare failed: " . $conn->error
    ]);*/
    exit;
}

            
            $status = '1';
// Bind parameters
$stmt->bind_param(
    "ssssssssssssssssssssss", 
    $usertype, $name, $firstname, $lastname, $middlename, 
    $account_number, $phoneNumber, $email, $ninAddress, $datetime, 
    $account_number, $status, $uuid, $encrypted_password, 
    $ninFirstname, $ninLastname, $ninMiddlename, $ninBirthdate, 
    $ninPhoto, $ninGender, $nin, $password
);

// Execute the statement
$process = $stmt->execute();
$stmt->close();
            if ($process) {
                echo json_encode([
                    "statusCode" => 200,
                    "message" => "Phone Number Verified successfully. The status is verified.",
                    "phone" => $phoneNumber,
                    "data" => [
                        "id" => $id,
                        "applicant" => [
                            "firstname" => $applicantFirstname,
                            "lastname" => $applicantLastname
                        ],
                        "summary" => [
                            "nin_check" => [
                                "status" => $ninCheckStatus,
                                "fieldMatches" => [
                                    "firstname" => $ninCheckFirstNameMatch,
                                    "lastname" => $ninCheckLastNameMatch
                                ]
                            ]
                        ],
                        "status" => [
                            "state" => $state,
                            "status" => $status
                        ],
                        "nin" => [
                            "nin" => $nin,
                            "firstname" => $ninFirstname,
                            "lastname" => $ninLastname,
                            "middlename" => $ninMiddlename,
                            "phone" => $ninPhone,
                            "gender" => $ninGender,
                            "birthdate" => $ninBirthdate,
                            "address" => $ninAddress,
                            "photo" => $ninPhoto  // base64 encoded photo
                        ]
                    ]
                ]);
            } else {
                echo json_encode([
                    "status" => 404,
                    "statusCode" => 404,
                    "message" => "Information not submitted successfully.",
                    "error" => "Database error."
                ]);
            }
        }
    } else {
        echo json_encode([
            "status" => 404,
            "statusCode" => 404,
            "message" => "NIN not found. Provide a valid NIN.",
            "error" => "Invalid NIN"
        ]);
    }
} else {
    echo json_encode(['error' => 'Failed to decode JSON response: ' . json_last_error_msg()]);
    exit;
}

?>
