document.getElementById('receipt-input').addEventListener('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const img = document.getElementById('receipt-image');
            img.src = e.target.result;
            img.style.display = 'block';

            // Process the image with Tesseract.js
            Tesseract.recognize(
                img.src,
                'eng',
                {
                    logger: m => console.log(m)
                }
            ).then(({ data: { text } }) => {
                console.log(text); // Log the full OCR text to help with debugging
                const extractedData = extractDynamicData(text);
                displayOutput(extractedData);
            }).catch(err => {
                console.error(err);
                document.getElementById('output').textContent = "Error processing image.";
            });
        }
        reader.readAsDataURL(file);
    }
});

function extractDynamicData(text) {
    const data = {};
    const lines = text.split('\n').map(line => line.trim()).filter(line => line);

    data.storeName = lines.find(line => /Pharmacy|Superstore|Mart|Store|Stores|Shop|Mart/i.test(line)) || 'Store Name Not Found';
    data.date = lines.find(line => /\b\d{1,2}\/\d{1,2}\/\d{2,4}\b/.test(line)) || 'Date Not Found';
    data.time = lines.find(line => /\b\d{1,2}:\d{2}(?::\d{2})?\s?(?:AM|PM)?\b/i.test(line)) || 'Time Not Found';
    data.address = lines.find(line => /\d+.*(Road|Street|Ave|Boulevard|Plaza|Lane|Close|Drive|Plot|PLOT)/i.test(line)) || 'Address Not Found';

    data.items = [];
    let itemSectionStarted = false;

    lines.forEach(line => {
        // Start capturing items after detecting a line that typically precedes items
      if (/^Item #|Item Name|Item|Qty|Price|Extended|Amount/i.test(line)) {
    itemSectionStarted = true;
    console.log("Item section detected!");
    return;
}

        // Extract items: flexible pattern assuming items may be listed with description, quantity, and price
if (itemSectionStarted) {
    // Define patterns for non-item lines (e.g., "Subtotal", "RECEIPT TOTAL", "Debit Card")
    const nonItemPatterns = /(Subtotal|RECEIPT TOTAL|Debit Card|VAT|Thanks for shopping)/i;

    // Skip non-item lines
    if (nonItemPatterns.test(line)) {
        return;
    }

    // Try to match item lines
    const match = line.match(/^\d+\s+(.+?)\s+N?([\d,]+\.\d{2})$/);
    if (match) {
        data.items.push({
            description: match[1].trim(),       // Description
            quantity: '1',                      // Default quantity to 1 if not specified
            price: match[2].trim()              // Price
        });
    }
}


    });

    const totalPattern = /Total:\s*\d+\.\d{2}|Grand Total:\s*\d+\.\d{2}|Amount Due:\s*\d+\.\d{2}/i;
    const totalLine = lines.find(line => totalPattern.test(line));
    if (totalLine) {
        data.totalAmount = totalLine.match(/\d+\.\d{2}/)[0];
    } else {
        data.totalAmount = 'Total Not Found';
    }

    return data;
}

function displayOutput(data) {
    const outputDiv = document.getElementById('output');
    outputDiv.innerHTML = `<strong>Extracted Data:</strong><br>`;
    outputDiv.innerHTML += `Store Name: ${data.storeName}<br>`;
    outputDiv.innerHTML += `Date: ${data.date}<br>`;
    outputDiv.innerHTML += `Time: ${data.time}<br>`;
    outputDiv.innerHTML += `Address: ${data.address}<br>`;
    outputDiv.innerHTML += `Total Amount: ${data.totalAmount}<br><br>`;
    
    outputDiv.innerHTML += "<strong>Items:</strong><br>";
    if (data.items.length > 0) {
        data.items.forEach(item => {
            outputDiv.innerHTML += `Description: ${item.description}, Quantity: ${item.quantity}, Price: ${item.price}<br>`;
        });
    } else {
        outputDiv.innerHTML += "No items found.<br>";
    }
}
