<?php require_once("my-header.php");  
 ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
?>

  <!--start main wrapper-->
  <main class="main-wrapper">
    <div class="main-content">
      <!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-4">
					<div class="breadcrumb-title pe-3">  Meeting Report</div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">Meeting Report</li>
							</ol>
						</nav>
					</div>
					 
				</div>
				<!--end breadcrumb-->
        <hr> 
        		 <?php
											include("admin-includes/update_column.php");
											include("admin-includes/deleteclass.php");
											//deleteclass
											
											?>
                                       
        
				<div class="card">
					<div class="card-body">
              	<div class="table-responsive">
						 
<?php
 
$worker_id = 'JC-147-374083'; 
// Sanitize the worker_id
$worker_id = $conn->real_escape_string($worker_id);
$attendance_log_MAX = $myName->showName($conn, "
    SELECT MAX(attendance_count) AS highest_attendance
    FROM (
        SELECT COUNT(`id`) AS attendance_count
        FROM `attendance_log`
        WHERE `status` = '1' AND `service_id` = 1
        GROUP BY `registered_by`
    ) AS subquery;
"); 

// SQL query for a specific worker
$sql = "SELECT 
            CONCAT(j.surname, ' ', j.first_name) AS full_name,
            j.phone_number,
            d.department_name AS department,
            SUM(CASE WHEN a.service_id = 1 THEN 1 ELSE 0 END) AS total_present_group_1,
            SUM(CASE WHEN a.service_id BETWEEN 4 AND 10 THEN 1 ELSE 0 END) AS total_present_group_4_10
        FROM 
            attendance_log a
        JOIN 
            js_workers j ON a.registered_by = j.worker_id
        JOIN 
            department d ON j.department = d.id 
        WHERE 
            a.status = 1 AND j.worker_id = '$worker_id'
        GROUP BY 
            j.worker_id";

$result = $conn->query($sql);

if ($result) {
    $data = $result->fetch_assoc();
} else {
    die("Query failed: " . $conn->error);
}

$conn->close();
?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<h2>Attendance Charts for <?php echo htmlspecialchars($data['full_name']); ?></h2>
<div>
    <canvas id="group1Chart"></canvas>
    <canvas id="group2Chart"></canvas>
</div>
<script>
    var group1Ctx = document.getElementById('group1Chart').getContext('2d');
    var group1Chart = new Chart(group1Ctx, {
        type: 'pie',
        data: {
            labels: ['WORKERS MEETING: Present', 'Absent'],
            datasets: [{
                label: 'Attendance Group 1',
                data: [<?php echo $data['total_present_group_1']; ?>, <?php echo ($attendance_log_MAX - $data['total_present_group_1']); ?>],
                backgroundColor: ['rgba(54, 162, 235, 0.2)', 'rgba(255, 99, 132, 0.2)'],
                borderColor: ['rgba(54, 162, 235, 1)', 'rgba(255, 99, 132, 1)'],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true
        }
    });

    var group2Ctx = document.getElementById('group2Chart').getContext('2d');
    var group2Chart = new Chart(group2Ctx, {
        type: 'pie',
        data: {
            labels: ['100 DAYS FASTING AND PRAYER: Present', 'Absent'],
            datasets: [{
                label: 'Attendance Group 2',
                data: [<?php echo $data['total_present_group_4_10']; ?>, <?php echo (100 - $data['total_present_group_4_10']); ?>],
                backgroundColor: ['rgba(75, 192, 192, 0.2)', 'rgba(255, 206, 86, 0.2)'],
                borderColor: ['rgba(75, 192, 192, 1)', 'rgba(255, 206, 86, 1)'],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true
        }
    });
</script>

		 
						</div>
					</div>
				</div>


    </div>
  </main>

 

  <!--end main wrapper-->

<?php require_once("my-footer.php"); ?>

 